// PCMag_OLTP_Read_Join.cpp

#include "stdafx.h"
#include "PCMAG_ORA8.h"
#include "PCMag_OLTP_Read_Join.h"

// IMPLEMENT_SERIAL macro calls
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_01,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_02,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_03,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_04,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_05,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_06,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_07,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_08,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_09,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_10,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_11,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_12,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_13,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Join_14,CXact,1)

// ================================================================================

// CXact_OLTP_Read_Join_01

CXact_OLTP_Read_Join_01::CXact_OLTP_Read_Join_01 (void)
{
	m_szName		= "OLTP Read Join 01";
	m_szDescription = "select updates.p_key, updates.p_code, hundred.h_date, hundred.h_signed, hundred.h_name, hundred.h_address from updates, hundred where updates.p_key = :randbase and updates.p_key = hundred.h_key";
	m_szSQL			= "select updates.p_key, updates.p_code, hundred.h_date, hundred.h_signed, hundred.h_name, hundred.h_address from updates, hundred where updates.p_key = :randbase and updates.p_key = hundred.h_key";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+01;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_01::~CXact_OLTP_Read_Join_01 (void)
{
}

BOOL CXact_OLTP_Read_Join_01::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_01::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_01::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
	OCIBind *pBind;
	unsigned long randbase;
#define OLTP_READ_JOIN_01_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_JOIN_01_NUM_COLS];
	struct OLTP_READ_JOIN_01 {
		int p_key;
		char p_code[11];
		char h_date[10];
		int h_signed;
		char h_name[21];
		char h_address[81];
	};
	typedef struct OLTP_READ_JOIN_01 OLTP_READ_JOIN_01;
	struct OLTP_READ_JOIN_01_INDICATORS {
		short p_key;
		short p_code;
		short h_date;
		short h_signed;
		short h_name;
		short h_address;
	};
	typedef struct OLTP_READ_JOIN_01_INDICATORS OLTP_READ_JOIN_01_INDICATORS;
	OLTP_READ_JOIN_01 oltp_read_join_01_array[NUM_ROWS];
	OLTP_READ_JOIN_01_INDICATORS oltp_read_join_01_indicators_array[NUM_ROWS];

	// initialize variables
	pBind = (OCIBind *)NULL;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_01_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind, pError, (text *) ":randbase", -1, (dvoid *)&randbase, (sword)sizeof(randbase), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_join_01_array[0].p_key, (ub2)sizeof(oltp_read_join_01_array[0].p_key), SQLT_INT, (dvoid *)&oltp_read_join_01_indicators_array[0].p_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_01_array[0].p_code, (ub2)sizeof(oltp_read_join_01_array[0].p_code), SQLT_STR, (dvoid *)&oltp_read_join_01_indicators_array[0].p_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)oltp_read_join_01_array[0].h_date, (ub2)sizeof(oltp_read_join_01_array[0].h_date), SQLT_STR, (dvoid *)&oltp_read_join_01_indicators_array[0].h_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_join_01_array[0].h_signed, (ub2)sizeof(oltp_read_join_01_array[0].h_signed), SQLT_INT, (dvoid *)&oltp_read_join_01_indicators_array[0].h_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_join_01_array[0].h_name, (ub2)sizeof(oltp_read_join_01_array[0].h_name), SQLT_STR, (dvoid *)&oltp_read_join_01_indicators_array[0].h_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_join_01_array[0].h_address, (ub2)sizeof(oltp_read_join_01_array[0].h_address), SQLT_STR, (dvoid *)&oltp_read_join_01_indicators_array[0].h_address, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_01_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_01_array[0]), (ub4)sizeof(oltp_read_join_01_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// initialize variables
	randbase = (long) m_CRandom.GetRandom(2,1000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_01_array[iRowLoop].p_key << tab
					<< oltp_read_join_01_array[iRowLoop].p_code << tab
					<< oltp_read_join_01_array[iRowLoop].h_date << tab
					<< oltp_read_join_01_array[iRowLoop].h_signed << tab
					<< oltp_read_join_01_array[iRowLoop].h_name << tab
					<< oltp_read_join_01_array[iRowLoop].h_address << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_01_array[iRowLoop%NUM_ROWS].p_key << tab
					<< oltp_read_join_01_array[iRowLoop%NUM_ROWS].p_code << tab
					<< oltp_read_join_01_array[iRowLoop%NUM_ROWS].h_date << tab
					<< oltp_read_join_01_array[iRowLoop%NUM_ROWS].h_signed << tab
					<< oltp_read_join_01_array[iRowLoop%NUM_ROWS].h_name << tab
					<< oltp_read_join_01_array[iRowLoop%NUM_ROWS].h_address << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_01_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_02

CXact_OLTP_Read_Join_02::CXact_OLTP_Read_Join_02 (void)
{
	m_szName		= "OLTP Read Join 02";
	m_szDescription = "select twomill.p_key, twomill.p_code, uniques.u_date, uniques.u_signed, uniques.u_name from twomill, uniques where twomill.p_key = :randtwomill and twomill.p_code = uniques.u_code";
	m_szSQL			= "select twomill.p_key, twomill.p_code, uniques.u_date, uniques.u_signed, uniques.u_name from twomill, uniques where twomill.p_key = :randtwomill and twomill.p_code = uniques.u_code";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+02;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_02::~CXact_OLTP_Read_Join_02 (void)
{
}

BOOL CXact_OLTP_Read_Join_02::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_02::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_02::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
	OCIBind *pBind;
	unsigned long randtwomill;
#define OLTP_READ_JOIN_02_NUM_COLS 5
	OCIDefine* pDefineArray[OLTP_READ_JOIN_02_NUM_COLS];
	struct OLTP_READ_JOIN_02 {
		int p_key;
		char p_code[11];
		char u_date[10];
		int u_signed;
		char u_name[21];
	};
	typedef struct OLTP_READ_JOIN_02 OLTP_READ_JOIN_02;
	struct OLTP_READ_JOIN_02_INDICATORS {
		short p_key;
		short p_code;
		short u_date;
		short u_signed;
		short u_name;
	};
	typedef struct OLTP_READ_JOIN_02_INDICATORS OLTP_READ_JOIN_02_INDICATORS;
	OLTP_READ_JOIN_02 oltp_read_join_02_array[NUM_ROWS];
	OLTP_READ_JOIN_02_INDICATORS oltp_read_join_02_indicators_array[NUM_ROWS];

	// initialize variables
	pBind = (OCIBind *)NULL;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_02_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind, pError, (text *) ":randtwomill", -1, (dvoid *)&randtwomill, (sword)sizeof(randtwomill), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_join_02_array[0].p_key, (ub2)sizeof(oltp_read_join_02_array[0].p_key), SQLT_INT, (dvoid *)&oltp_read_join_02_indicators_array[0].p_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_02_array[0].p_code, (ub2)sizeof(oltp_read_join_02_array[0].p_code), SQLT_STR, (dvoid *)&oltp_read_join_02_indicators_array[0].p_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)oltp_read_join_02_array[0].u_date, (ub2)sizeof(oltp_read_join_02_array[0].u_date), SQLT_STR, (dvoid *)&oltp_read_join_02_indicators_array[0].u_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_join_02_array[0].u_signed, (ub2)sizeof(oltp_read_join_02_array[0].u_signed), SQLT_INT, (dvoid *)&oltp_read_join_02_indicators_array[0].u_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_join_02_array[0].u_name, (ub2)sizeof(oltp_read_join_02_array[0].u_name), SQLT_STR, (dvoid *)&oltp_read_join_02_indicators_array[0].u_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_02_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_02_array[0]), (ub4)sizeof(oltp_read_join_02_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// initialize variables
	randtwomill = (long) m_CRandom.GetRandom(2,2000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_02_array[iRowLoop].p_key << tab
					<< oltp_read_join_02_array[iRowLoop].p_code << tab
					<< oltp_read_join_02_array[iRowLoop].u_date << tab
					<< oltp_read_join_02_array[iRowLoop].u_signed << tab
					<< oltp_read_join_02_array[iRowLoop].u_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_02_array[iRowLoop%NUM_ROWS].p_key << tab
					<< oltp_read_join_02_array[iRowLoop%NUM_ROWS].p_code << tab
					<< oltp_read_join_02_array[iRowLoop%NUM_ROWS].u_date << tab
					<< oltp_read_join_02_array[iRowLoop%NUM_ROWS].u_signed << tab
					<< oltp_read_join_02_array[iRowLoop%NUM_ROWS].u_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_02_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_03

CXact_OLTP_Read_Join_03::CXact_OLTP_Read_Join_03 (void)
{
	m_szName		= "OLTP Read Join 03";
	m_szDescription = "select fivemill.h_key, fivemill.h_code, updates.p_date, updates.p_signed, updates.p_name from fivemill, updates where fivemill.h_key in (:randfivemill1,:randfivemill2,:randfivemill3,:randfivemill4,:randfivemill5) and fivemill.h_key = updates.p_key order by fivemill.h_code";
	m_szSQL			= "select fivemill.h_key, fivemill.h_code, updates.p_date, updates.p_signed, updates.p_name from fivemill, updates where fivemill.h_key in (:randfivemill1,:randfivemill2,:randfivemill3,:randfivemill4,:randfivemill5) and fivemill.h_key = updates.p_key order by fivemill.h_code";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+03;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_03::~CXact_OLTP_Read_Join_03 (void)
{
}

BOOL CXact_OLTP_Read_Join_03::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_03::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_03::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
	OCIBind *pBind1;
	OCIBind *pBind2;
	OCIBind *pBind3;
	OCIBind *pBind4;
	OCIBind *pBind5;
	unsigned long randfivemill1;
	unsigned long randfivemill2;
	unsigned long randfivemill3;
	unsigned long randfivemill4;
	unsigned long randfivemill5;
#define OLTP_READ_JOIN_03_NUM_COLS 5
	OCIDefine* pDefineArray[OLTP_READ_JOIN_03_NUM_COLS];
	struct OLTP_READ_JOIN_03 {
		int h_key;
		char h_code[11];
		char p_date[10];
		int p_signed;
		char p_name[21];
	};
	typedef struct OLTP_READ_JOIN_03 OLTP_READ_JOIN_03;
	struct OLTP_READ_JOIN_03_INDICATORS {
		short h_key;
		short h_code;
		short p_date;
		short p_signed;
		short p_name;
	};
	typedef struct OLTP_READ_JOIN_03_INDICATORS OLTP_READ_JOIN_03_INDICATORS;
	OLTP_READ_JOIN_03 oltp_read_join_03_array[NUM_ROWS];
	OLTP_READ_JOIN_03_INDICATORS oltp_read_join_03_indicators_array[NUM_ROWS];

	// initialize variables
	pBind1 = (OCIBind *)NULL;
	pBind2 = (OCIBind *)NULL;
	pBind3 = (OCIBind *)NULL;
	pBind4 = (OCIBind *)NULL;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_03_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind1, pError, (text *) ":randfivemill1", -1, (dvoid *)&randfivemill1, (sword)sizeof(randfivemill1), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIBindByName (pStmt, &pBind2, pError, (text *) ":randfivemill2", -1, (dvoid *)&randfivemill2, (sword)sizeof(randfivemill2), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIBindByName (pStmt, &pBind3, pError, (text *) ":randfivemill3", -1, (dvoid *)&randfivemill3, (sword)sizeof(randfivemill3), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIBindByName (pStmt, &pBind4, pError, (text *) ":randfivemill4", -1, (dvoid *)&randfivemill4, (sword)sizeof(randfivemill4), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIBindByName (pStmt, &pBind5, pError, (text *) ":randfivemill5", -1, (dvoid *)&randfivemill5, (sword)sizeof(randfivemill5), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_join_03_array[0].h_key, (ub2)sizeof(oltp_read_join_03_array[0].h_key), SQLT_INT, (dvoid *)&oltp_read_join_03_indicators_array[0].h_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_03_array[0].h_code, (ub2)sizeof(oltp_read_join_03_array[0].h_code), SQLT_STR, (dvoid *)&oltp_read_join_03_indicators_array[0].h_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)oltp_read_join_03_array[0].p_date, (ub2)sizeof(oltp_read_join_03_array[0].p_date), SQLT_STR, (dvoid *)&oltp_read_join_03_indicators_array[0].p_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_join_03_array[0].p_signed, (ub2)sizeof(oltp_read_join_03_array[0].p_signed), SQLT_INT, (dvoid *)&oltp_read_join_03_indicators_array[0].p_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_join_03_array[0].p_name, (ub2)sizeof(oltp_read_join_03_array[0].p_name), SQLT_STR, (dvoid *)&oltp_read_join_03_indicators_array[0].p_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_03_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_03_array[0]), (ub4)sizeof(oltp_read_join_03_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// initialize variables
	randfivemill1 = (long) m_CRandom.GetRandom(2,5000000);
	randfivemill2 = (long) m_CRandom.GetRandom(2,5000000);
	randfivemill3 = (long) m_CRandom.GetRandom(2,5000000);
	randfivemill4 = (long) m_CRandom.GetRandom(2,5000000);
	randfivemill5 = (long) m_CRandom.GetRandom(2,5000000);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_03_array[iRowLoop].h_key << tab
					<< oltp_read_join_03_array[iRowLoop].h_code << tab
					<< oltp_read_join_03_array[iRowLoop].p_date << tab
					<< oltp_read_join_03_array[iRowLoop].p_signed << tab
					<< oltp_read_join_03_array[iRowLoop].p_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_03_array[iRowLoop%NUM_ROWS].h_key << tab
					<< oltp_read_join_03_array[iRowLoop%NUM_ROWS].h_code << tab
					<< oltp_read_join_03_array[iRowLoop%NUM_ROWS].p_date << tab
					<< oltp_read_join_03_array[iRowLoop%NUM_ROWS].p_signed << tab
					<< oltp_read_join_03_array[iRowLoop%NUM_ROWS].p_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_03_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_04

CXact_OLTP_Read_Join_04::CXact_OLTP_Read_Join_04 (void)
{
	m_szName		= "OLTP Read Join 04";
	m_szDescription = "select updates.p_key, updates.p_code, hundred.h_date, hundred.h_signed, hundred.h_name, hundred.h_address from updates, hundred where (hundred.h_key between :randbase and :randbaseplus) and updates.p_key = hundred.h_key order by updates.p_code, hundred.h_date";
	m_szSQL			= "select updates.p_key, updates.p_code, hundred.h_date, hundred.h_signed, hundred.h_name, hundred.h_address from updates, hundred where (hundred.h_key between :randbase and :randbaseplus) and updates.p_key = hundred.h_key order by updates.p_code, hundred.h_date";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+04;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_04::~CXact_OLTP_Read_Join_04 (void)
{
}

BOOL CXact_OLTP_Read_Join_04::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_04::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_04::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
	OCIBind *pBind1;
	OCIBind *pBind2;
	unsigned long randbase;
	unsigned long randbaseplus;
#define OLTP_READ_JOIN_04_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_JOIN_04_NUM_COLS];
	struct OLTP_READ_JOIN_04 {
		int p_key;
		char p_code[11];
		char h_date[10];
		int h_signed;
		char h_name[21];
		char h_address[81];
	};
	typedef struct OLTP_READ_JOIN_04 OLTP_READ_JOIN_04;
	struct OLTP_READ_JOIN_04_INDICATORS {
		short p_key;
		short p_code;
		short h_date;
		short h_signed;
		short h_name;
		short h_address;
	};
	typedef struct OLTP_READ_JOIN_04_INDICATORS OLTP_READ_JOIN_04_INDICATORS;
	OLTP_READ_JOIN_04 oltp_read_join_04_array[NUM_ROWS];
	OLTP_READ_JOIN_04_INDICATORS oltp_read_join_04_indicators_array[NUM_ROWS];

	// initialize variables
	pBind1 = (OCIBind *)NULL;
	pBind2 = (OCIBind *)NULL;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_04_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind input variables
	ReturnCode = OCIBindByName (pStmt, &pBind1, pError, (text *) ":randbase", -1, (dvoid *)&randbase, (sword)sizeof(randbase), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIBindByName (pStmt, &pBind2, pError, (text *) ":randbaseplus", -1, (dvoid *)&randbaseplus, (sword)sizeof(randbaseplus), SQLT_INT, (dvoid *)NULL, (ub2 *)0, (ub2 *)0, (ub4) 0, (ub4 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_join_04_array[0].p_key, (ub2)sizeof(oltp_read_join_04_array[0].p_key), SQLT_INT, (dvoid *)&oltp_read_join_04_indicators_array[0].p_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_04_array[0].p_code, (ub2)sizeof(oltp_read_join_04_array[0].p_code), SQLT_STR, (dvoid *)&oltp_read_join_04_indicators_array[0].p_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)oltp_read_join_04_array[0].h_date, (ub2)sizeof(oltp_read_join_04_array[0].h_date), SQLT_STR, (dvoid *)&oltp_read_join_04_indicators_array[0].h_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_join_04_array[0].h_signed, (ub2)sizeof(oltp_read_join_04_array[0].h_signed), SQLT_INT, (dvoid *)&oltp_read_join_04_indicators_array[0].h_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_join_04_array[0].h_name, (ub2)sizeof(oltp_read_join_04_array[0].h_name), SQLT_STR, (dvoid *)&oltp_read_join_04_indicators_array[0].h_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_join_04_array[0].h_address, (ub2)sizeof(oltp_read_join_04_array[0].h_address), SQLT_STR, (dvoid *)&oltp_read_join_04_indicators_array[0].h_address, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_04_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_04_array[0]), (ub4)sizeof(oltp_read_join_04_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// initialize variables
	randbase = (long) m_CRandom.GetRandom(2,1000000);
	randbaseplus = randbase + 20;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_04_array[iRowLoop].p_key << tab
					<< oltp_read_join_04_array[iRowLoop].p_code << tab
					<< oltp_read_join_04_array[iRowLoop].h_date << tab
					<< oltp_read_join_04_array[iRowLoop].h_signed << tab
					<< oltp_read_join_04_array[iRowLoop].h_name << tab
					<< oltp_read_join_04_array[iRowLoop].h_address << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_04_array[iRowLoop%NUM_ROWS].p_key << tab
					<< oltp_read_join_04_array[iRowLoop%NUM_ROWS].p_code << tab
					<< oltp_read_join_04_array[iRowLoop%NUM_ROWS].h_date << tab
					<< oltp_read_join_04_array[iRowLoop%NUM_ROWS].h_signed << tab
					<< oltp_read_join_04_array[iRowLoop%NUM_ROWS].h_name << tab
					<< oltp_read_join_04_array[iRowLoop%NUM_ROWS].h_address << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_04_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_05

CXact_OLTP_Read_Join_05::CXact_OLTP_Read_Join_05 (void)
{
	m_szName		= "OLTP Read Join 05";
	m_szDescription = "select uniques.u_key, uniques.u_name, tenpct.t_key, tenpct.t_signed from uniques, tenpct where uniques.u_key >= 1000000000 and tenpct.t_int <= uniques.u_int and tenpct.t_key >= 999990000";
	m_szSQL			= "select uniques.u_key, uniques.u_name, tenpct.t_key, tenpct.t_signed from uniques, tenpct where uniques.u_key >= 1000000000 and tenpct.t_int <= uniques.u_int and tenpct.t_key >= 999990000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+05;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_05::~CXact_OLTP_Read_Join_05 (void)
{
}

BOOL CXact_OLTP_Read_Join_05::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_05::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_05::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_JOIN_05_NUM_COLS 4
	OCIDefine* pDefineArray[OLTP_READ_JOIN_05_NUM_COLS];
	struct OLTP_READ_JOIN_05 {
		int u_key;
		char u_name[21];
		int t_key;
		int t_signed;
	};
	typedef struct OLTP_READ_JOIN_05 OLTP_READ_JOIN_05;
	struct OLTP_READ_JOIN_05_INDICATORS {
		short u_key;
		short u_name;
		short t_key;
		short t_signed;
	};
	typedef struct OLTP_READ_JOIN_05_INDICATORS OLTP_READ_JOIN_05_INDICATORS;
	OLTP_READ_JOIN_05 oltp_read_join_05_array[NUM_ROWS];
	OLTP_READ_JOIN_05_INDICATORS oltp_read_join_05_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_05_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_join_05_array[0].u_key, (ub2)sizeof(oltp_read_join_05_array[0].u_key), SQLT_INT, (dvoid *)&oltp_read_join_05_indicators_array[0].u_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_05_array[0].u_name, (ub2)sizeof(oltp_read_join_05_array[0].u_name), SQLT_STR, (dvoid *)&oltp_read_join_05_indicators_array[0].u_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_join_05_array[0].t_key, (ub2)sizeof(oltp_read_join_05_array[0].t_key), SQLT_INT, (dvoid *)&oltp_read_join_05_indicators_array[0].t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&oltp_read_join_05_array[0].t_signed, (ub2)sizeof(oltp_read_join_05_array[0].t_signed), SQLT_INT, (dvoid *)&oltp_read_join_05_indicators_array[0].t_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_05_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_05_array[0]), (ub4)sizeof(oltp_read_join_05_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_05_array[iRowLoop].u_key << tab
					<< oltp_read_join_05_array[iRowLoop].u_name << tab
					<< oltp_read_join_05_array[iRowLoop].t_key << tab
					<< oltp_read_join_05_array[iRowLoop].t_signed << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_05_array[iRowLoop%NUM_ROWS].u_key << tab
					<< oltp_read_join_05_array[iRowLoop%NUM_ROWS].u_name << tab
					<< oltp_read_join_05_array[iRowLoop%NUM_ROWS].t_key << tab
					<< oltp_read_join_05_array[iRowLoop%NUM_ROWS].t_signed << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_05_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_06

CXact_OLTP_Read_Join_06::CXact_OLTP_Read_Join_06 (void)
{
	m_szName		= "OLTP Read Join 06";
	m_szDescription = "select distinct uniques.u_signed, uniques.u_name, fourram.p_signed, fourram.p_name from uniques, fourram where uniques.u_key = fourram.p_key and uniques.u_code like 'AA%'";
	m_szSQL			= "select distinct uniques.u_signed, uniques.u_name, fourram.p_signed, fourram.p_name from uniques, fourram where uniques.u_key = fourram.p_key and uniques.u_code like 'AA%'";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+06;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_06::~CXact_OLTP_Read_Join_06 (void)
{
}

BOOL CXact_OLTP_Read_Join_06::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_06::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_06::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_JOIN_06_NUM_COLS 4
	OCIDefine* pDefineArray[OLTP_READ_JOIN_06_NUM_COLS];
	struct OLTP_READ_JOIN_06 {
		int u_signed;
		char u_name[21];
		int p_signed;
		char p_name[21];
	};
	typedef struct OLTP_READ_JOIN_06 OLTP_READ_JOIN_06;
	struct OLTP_READ_JOIN_06_INDICATORS {
		short u_signed;
		short u_name;
		short p_signed;
		short p_name;
	};
	typedef struct OLTP_READ_JOIN_06_INDICATORS OLTP_READ_JOIN_06_INDICATORS;
	OLTP_READ_JOIN_06 oltp_read_join_06_array[NUM_ROWS];
	OLTP_READ_JOIN_06_INDICATORS oltp_read_join_06_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_06_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_join_06_array[0].u_signed, (ub2)sizeof(oltp_read_join_06_array[0].u_signed), SQLT_INT, (dvoid *)&oltp_read_join_06_indicators_array[0].u_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_06_array[0].u_name, (ub2)sizeof(oltp_read_join_06_array[0].u_name), SQLT_STR, (dvoid *)&oltp_read_join_06_indicators_array[0].u_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_join_06_array[0].p_signed, (ub2)sizeof(oltp_read_join_06_array[0].p_signed), SQLT_INT, (dvoid *)&oltp_read_join_06_indicators_array[0].p_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)oltp_read_join_06_array[0].p_name, (ub2)sizeof(oltp_read_join_06_array[0].p_name), SQLT_STR, (dvoid *)&oltp_read_join_06_indicators_array[0].p_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_06_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_06_array[0]), (ub4)sizeof(oltp_read_join_06_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_06_array[iRowLoop].u_signed << tab
					<< oltp_read_join_06_array[iRowLoop].u_name << tab
					<< oltp_read_join_06_array[iRowLoop].p_signed << tab
					<< oltp_read_join_06_array[iRowLoop].p_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_06_array[iRowLoop%NUM_ROWS].u_signed << tab
					<< oltp_read_join_06_array[iRowLoop%NUM_ROWS].u_name << tab
					<< oltp_read_join_06_array[iRowLoop%NUM_ROWS].p_signed << tab
					<< oltp_read_join_06_array[iRowLoop%NUM_ROWS].p_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_06_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_07

CXact_OLTP_Read_Join_07::CXact_OLTP_Read_Join_07 (void)
{
	m_szName		= "OLTP Read Join 07";
	m_szDescription = "select uniques.u_signed, uniques.u_name, hundred.h_signed, hundred.h_name from uniques, hundred where uniques.u_key = hundred.h_key and uniques.u_key = 1001";
	m_szSQL			= "select uniques.u_signed, uniques.u_name, hundred.h_signed, hundred.h_name from uniques, hundred where uniques.u_key = hundred.h_key and uniques.u_key = 1001";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+07;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_07::~CXact_OLTP_Read_Join_07 (void)
{
}

BOOL CXact_OLTP_Read_Join_07::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_07::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_07::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_JOIN_07_NUM_COLS 4
	OCIDefine* pDefineArray[OLTP_READ_JOIN_07_NUM_COLS];
	struct OLTP_READ_JOIN_07 {
		int u_signed;
		char u_name[21];
		int h_signed;
		char h_name[21];
	};
	typedef struct OLTP_READ_JOIN_07 OLTP_READ_JOIN_07;
	struct OLTP_READ_JOIN_07_INDICATORS {
		short u_signed;
		short u_name;
		short h_signed;
		short h_name;
	};
	typedef struct OLTP_READ_JOIN_07_INDICATORS OLTP_READ_JOIN_07_INDICATORS;
	OLTP_READ_JOIN_07 oltp_read_join_07_array[NUM_ROWS];
	OLTP_READ_JOIN_07_INDICATORS oltp_read_join_07_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_07_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_join_07_array[0].u_signed, (ub2)sizeof(oltp_read_join_07_array[0].u_signed), SQLT_INT, (dvoid *)&oltp_read_join_07_indicators_array[0].u_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_07_array[0].u_name, (ub2)sizeof(oltp_read_join_07_array[0].u_name), SQLT_STR, (dvoid *)&oltp_read_join_07_indicators_array[0].u_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_join_07_array[0].h_signed, (ub2)sizeof(oltp_read_join_07_array[0].h_signed), SQLT_INT, (dvoid *)&oltp_read_join_07_indicators_array[0].h_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)oltp_read_join_07_array[0].h_name, (ub2)sizeof(oltp_read_join_07_array[0].h_name), SQLT_STR, (dvoid *)&oltp_read_join_07_indicators_array[0].h_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_07_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_07_array[0]), (ub4)sizeof(oltp_read_join_07_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_07_array[iRowLoop].u_signed << tab
					<< oltp_read_join_07_array[iRowLoop].u_name << tab
					<< oltp_read_join_07_array[iRowLoop].h_signed << tab
					<< oltp_read_join_07_array[iRowLoop].h_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_07_array[iRowLoop%NUM_ROWS].u_signed << tab
					<< oltp_read_join_07_array[iRowLoop%NUM_ROWS].u_name << tab
					<< oltp_read_join_07_array[iRowLoop%NUM_ROWS].h_signed << tab
					<< oltp_read_join_07_array[iRowLoop%NUM_ROWS].h_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_07_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_08

CXact_OLTP_Read_Join_08::CXact_OLTP_Read_Join_08 (void)
{
	m_szName		= "OLTP Read Join 08";
	m_szDescription = "select uniques.u_signed, uniques.u_name, hundred.h_signed, hundred.h_name from uniques, hundred where uniques.u_code = hundred.h_code and uniques.u_code = 'BENCHMARKS'";
	m_szSQL			= "select uniques.u_signed, uniques.u_name, hundred.h_signed, hundred.h_name from uniques, hundred where uniques.u_code = hundred.h_code and uniques.u_code = 'BENCHMARKS'";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+8;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_08::~CXact_OLTP_Read_Join_08 (void)
{
}

BOOL CXact_OLTP_Read_Join_08::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_08::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_08::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_JOIN_08_NUM_COLS 4
	OCIDefine* pDefineArray[OLTP_READ_JOIN_08_NUM_COLS];
	struct OLTP_READ_JOIN_08 {
		int u_signed;
		char u_name[21];
		int h_signed;
		char h_name[21];
	};
	typedef struct OLTP_READ_JOIN_08 OLTP_READ_JOIN_08;
	struct OLTP_READ_JOIN_08_INDICATORS {
		short u_signed;
		short u_name;
		short h_signed;
		short h_name;
	};
	typedef struct OLTP_READ_JOIN_08_INDICATORS OLTP_READ_JOIN_08_INDICATORS;
	OLTP_READ_JOIN_08 oltp_read_join_08_array[NUM_ROWS];
	OLTP_READ_JOIN_08_INDICATORS oltp_read_join_08_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_08_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_join_08_array[0].u_signed, (ub2)sizeof(oltp_read_join_08_array[0].u_signed), SQLT_INT, (dvoid *)&oltp_read_join_08_indicators_array[0].u_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_08_array[0].u_name, (ub2)sizeof(oltp_read_join_08_array[0].u_name), SQLT_STR, (dvoid *)&oltp_read_join_08_indicators_array[0].u_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_join_08_array[0].h_signed, (ub2)sizeof(oltp_read_join_08_array[0].h_signed), SQLT_INT, (dvoid *)&oltp_read_join_08_indicators_array[0].h_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)oltp_read_join_08_array[0].h_name, (ub2)sizeof(oltp_read_join_08_array[0].h_name), SQLT_STR, (dvoid *)&oltp_read_join_08_indicators_array[0].h_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_08_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_08_array[0]), (ub4)sizeof(oltp_read_join_08_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_08_array[iRowLoop].u_signed << tab
					<< oltp_read_join_08_array[iRowLoop].u_name << tab
					<< oltp_read_join_08_array[iRowLoop].h_signed << tab
					<< oltp_read_join_08_array[iRowLoop].h_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_08_array[iRowLoop%NUM_ROWS].u_signed << tab
					<< oltp_read_join_08_array[iRowLoop%NUM_ROWS].u_name << tab
					<< oltp_read_join_08_array[iRowLoop%NUM_ROWS].h_signed << tab
					<< oltp_read_join_08_array[iRowLoop%NUM_ROWS].h_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_08_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_09

CXact_OLTP_Read_Join_09::CXact_OLTP_Read_Join_09 (void)
{
	m_szName		= "OLTP Read Join 09";
	m_szDescription = "select uniques.u_signed, uniques.u_date, hundred.h_signed, hundred.h_date, tenpct.t_signed, tenpct.t_date from uniques, hundred, tenpct where uniques.u_key = hundred.h_key and uniques.u_key = tenpct.t_key and uniques.u_key = 1001";
	m_szSQL			= "select uniques.u_signed, uniques.u_date, hundred.h_signed, hundred.h_date, tenpct.t_signed, tenpct.t_date from uniques, hundred, tenpct where uniques.u_key = hundred.h_key and uniques.u_key = tenpct.t_key and uniques.u_key = 1001";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+9;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_09::~CXact_OLTP_Read_Join_09 (void)
{
}

BOOL CXact_OLTP_Read_Join_09::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_09::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_09::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_JOIN_09_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_JOIN_09_NUM_COLS];
	struct OLTP_READ_JOIN_09 {
		int u_signed;
		char u_date[10];
		int h_signed;
		char h_date[10];
		int t_signed;
		char t_date[10];
	};
	typedef struct OLTP_READ_JOIN_09 OLTP_READ_JOIN_09;
	struct OLTP_READ_JOIN_09_INDICATORS {
		short u_signed;
		short u_date;
		short h_signed;
		short h_date;
		short t_signed;
		short t_date;
	};
	typedef struct OLTP_READ_JOIN_09_INDICATORS OLTP_READ_JOIN_09_INDICATORS;
	OLTP_READ_JOIN_09 oltp_read_join_09_array[NUM_ROWS];
	OLTP_READ_JOIN_09_INDICATORS oltp_read_join_09_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_09_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_join_09_array[0].u_signed, (ub2)sizeof(oltp_read_join_09_array[0].u_signed), SQLT_INT, (dvoid *)&oltp_read_join_09_indicators_array[0].u_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_09_array[0].u_date, (ub2)sizeof(oltp_read_join_09_array[0].u_date), SQLT_STR, (dvoid *)&oltp_read_join_09_indicators_array[0].u_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_join_09_array[0].h_signed, (ub2)sizeof(oltp_read_join_09_array[0].h_signed), SQLT_INT, (dvoid *)&oltp_read_join_09_indicators_array[0].h_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)oltp_read_join_09_array[0].h_date, (ub2)sizeof(oltp_read_join_09_array[0].h_date), SQLT_STR, (dvoid *)&oltp_read_join_09_indicators_array[0].h_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)&oltp_read_join_09_array[0].t_signed, (ub2)sizeof(oltp_read_join_09_array[0].t_signed), SQLT_INT, (dvoid *)&oltp_read_join_09_indicators_array[0].t_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_join_09_array[0].t_date, (ub2)sizeof(oltp_read_join_09_array[0].t_date), SQLT_STR, (dvoid *)&oltp_read_join_09_indicators_array[0].t_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_09_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_09_array[0]), (ub4)sizeof(oltp_read_join_09_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_09_array[iRowLoop].u_signed << tab
					<< oltp_read_join_09_array[iRowLoop].u_date << tab
					<< oltp_read_join_09_array[iRowLoop].h_signed << tab
					<< oltp_read_join_09_array[iRowLoop].h_date << tab
					<< oltp_read_join_09_array[iRowLoop].t_signed << tab
					<< oltp_read_join_09_array[iRowLoop].t_date << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_09_array[iRowLoop%NUM_ROWS].u_signed << tab
					<< oltp_read_join_09_array[iRowLoop%NUM_ROWS].u_date << tab
					<< oltp_read_join_09_array[iRowLoop%NUM_ROWS].h_signed << tab
					<< oltp_read_join_09_array[iRowLoop%NUM_ROWS].h_date << tab
					<< oltp_read_join_09_array[iRowLoop%NUM_ROWS].t_signed << tab
					<< oltp_read_join_09_array[iRowLoop%NUM_ROWS].t_date << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_09_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_10

CXact_OLTP_Read_Join_10::CXact_OLTP_Read_Join_10 (void)
{
	m_szName		= "OLTP Read Join 10";
	m_szDescription = "select uniques.u_signed, uniques.u_date, hundred.h_signed, hundred.h_date, tenpct.t_signed, tenpct.t_date from uniques, hundred, tenpct where uniques.u_code = hundred.h_code and uniques.u_code = tenpct.t_code and uniques.u_code = 'BENCHMARKS'";
	m_szSQL			= "select uniques.u_signed, uniques.u_date, hundred.h_signed, hundred.h_date, tenpct.t_signed, tenpct.t_date from uniques, hundred, tenpct where uniques.u_code = hundred.h_code and uniques.u_code = tenpct.t_code and uniques.u_code = 'BENCHMARKS'";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+10;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_10::~CXact_OLTP_Read_Join_10 (void)
{
}

BOOL CXact_OLTP_Read_Join_10::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_10::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_10::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_JOIN_10_NUM_COLS 6
	OCIDefine* pDefineArray[OLTP_READ_JOIN_10_NUM_COLS];
	struct OLTP_READ_JOIN_10 {
		int u_signed;
		char u_date[10];
		int h_signed;
		char h_date[10];
		int t_signed;
		char t_date[10];
	};
	typedef struct OLTP_READ_JOIN_10 OLTP_READ_JOIN_10;
	struct OLTP_READ_JOIN_10_INDICATORS {
		short u_signed;
		short u_date;
		short h_signed;
		short h_date;
		short t_signed;
		short t_date;
	};
	typedef struct OLTP_READ_JOIN_10_INDICATORS OLTP_READ_JOIN_10_INDICATORS;
	OLTP_READ_JOIN_10 oltp_read_join_10_array[NUM_ROWS];
	OLTP_READ_JOIN_10_INDICATORS oltp_read_join_10_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_10_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_join_10_array[0].u_signed, (ub2)sizeof(oltp_read_join_10_array[0].u_signed), SQLT_INT, (dvoid *)&oltp_read_join_10_indicators_array[0].u_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_10_array[0].u_date, (ub2)sizeof(oltp_read_join_10_array[0].u_date), SQLT_STR, (dvoid *)&oltp_read_join_10_indicators_array[0].u_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_join_10_array[0].h_signed, (ub2)sizeof(oltp_read_join_10_array[0].h_signed), SQLT_INT, (dvoid *)&oltp_read_join_10_indicators_array[0].h_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)oltp_read_join_10_array[0].h_date, (ub2)sizeof(oltp_read_join_10_array[0].h_date), SQLT_STR, (dvoid *)&oltp_read_join_10_indicators_array[0].h_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)&oltp_read_join_10_array[0].t_signed, (ub2)sizeof(oltp_read_join_10_array[0].t_signed), SQLT_INT, (dvoid *)&oltp_read_join_10_indicators_array[0].t_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)oltp_read_join_10_array[0].t_date, (ub2)sizeof(oltp_read_join_10_array[0].t_date), SQLT_STR, (dvoid *)&oltp_read_join_10_indicators_array[0].t_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_10_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_10_array[0]), (ub4)sizeof(oltp_read_join_10_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_10_array[iRowLoop].u_signed << tab
					<< oltp_read_join_10_array[iRowLoop].u_date << tab
					<< oltp_read_join_10_array[iRowLoop].h_signed << tab
					<< oltp_read_join_10_array[iRowLoop].h_date << tab
					<< oltp_read_join_10_array[iRowLoop].t_signed << tab
					<< oltp_read_join_10_array[iRowLoop].t_date << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_10_array[iRowLoop%NUM_ROWS].u_signed << tab
					<< oltp_read_join_10_array[iRowLoop%NUM_ROWS].u_date << tab
					<< oltp_read_join_10_array[iRowLoop%NUM_ROWS].h_signed << tab
					<< oltp_read_join_10_array[iRowLoop%NUM_ROWS].h_date << tab
					<< oltp_read_join_10_array[iRowLoop%NUM_ROWS].t_signed << tab
					<< oltp_read_join_10_array[iRowLoop%NUM_ROWS].t_date << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_10_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_11

CXact_OLTP_Read_Join_11::CXact_OLTP_Read_Join_11 (void)
{
	m_szName		= "OLTP Read Join 11";
	m_szDescription = "select uniques.u_date, hundred.h_date, tenpct.t_date, updates.p_date from uniques, hundred, tenpct, updates where uniques.u_key = hundred.h_key and uniques.u_key = tenpct.t_key and uniques.u_key = updates.p_key and uniques.u_key = 1001";
	m_szSQL			= "select uniques.u_date, hundred.h_date, tenpct.t_date, updates.p_date from uniques, hundred, tenpct, updates where uniques.u_key = hundred.h_key and uniques.u_key = tenpct.t_key and uniques.u_key = updates.p_key and uniques.u_key = 1001";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+11;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_11::~CXact_OLTP_Read_Join_11 (void)
{
}

BOOL CXact_OLTP_Read_Join_11::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_11::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_11::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_JOIN_11_NUM_COLS 4
	OCIDefine* pDefineArray[OLTP_READ_JOIN_11_NUM_COLS];
	struct OLTP_READ_JOIN_11 {
		char u_date[10];
		char h_date[10];
		char t_date[10];
		char p_date[10];
	};
	typedef struct OLTP_READ_JOIN_11 OLTP_READ_JOIN_11;
	struct OLTP_READ_JOIN_11_INDICATORS {
		short u_date;
		short h_date;
		short t_date;
		short p_date;
	};
	typedef struct OLTP_READ_JOIN_11_INDICATORS OLTP_READ_JOIN_11_INDICATORS;
	OLTP_READ_JOIN_11 oltp_read_join_11_array[NUM_ROWS];
	OLTP_READ_JOIN_11_INDICATORS oltp_read_join_11_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_11_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)oltp_read_join_11_array[0].u_date, (ub2)sizeof(oltp_read_join_11_array[0].u_date), SQLT_STR, (dvoid *)&oltp_read_join_11_indicators_array[0].u_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_11_array[0].h_date, (ub2)sizeof(oltp_read_join_11_array[0].h_date), SQLT_STR, (dvoid *)&oltp_read_join_11_indicators_array[0].h_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)oltp_read_join_11_array[0].t_date, (ub2)sizeof(oltp_read_join_11_array[0].t_date), SQLT_STR, (dvoid *)&oltp_read_join_11_indicators_array[0].t_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)oltp_read_join_11_array[0].p_date, (ub2)sizeof(oltp_read_join_11_array[0].p_date), SQLT_STR, (dvoid *)&oltp_read_join_11_indicators_array[0].p_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_11_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_11_array[0]), (ub4)sizeof(oltp_read_join_11_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_11_array[iRowLoop].u_date << tab
					<< oltp_read_join_11_array[iRowLoop].h_date << tab
					<< oltp_read_join_11_array[iRowLoop].t_date << tab
					<< oltp_read_join_11_array[iRowLoop].p_date << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_11_array[iRowLoop%NUM_ROWS].u_date << tab
					<< oltp_read_join_11_array[iRowLoop%NUM_ROWS].h_date << tab
					<< oltp_read_join_11_array[iRowLoop%NUM_ROWS].t_date << tab
					<< oltp_read_join_11_array[iRowLoop%NUM_ROWS].p_date << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_11_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_12

CXact_OLTP_Read_Join_12::CXact_OLTP_Read_Join_12 (void)
{
	m_szName		= "OLTP Read Join 12";
	m_szDescription = "select uniques.u_date, hundred.h_date, tenpct.t_date, updates.p_date from uniques, hundred, tenpct, updates where uniques.u_code = hundred.h_code and uniques.u_code = tenpct.t_code and uniques.u_code = updates.p_code and uniques.u_code = 'BENCHMARKS'";
	m_szSQL			= "select uniques.u_date, hundred.h_date, tenpct.t_date, updates.p_date from uniques, hundred, tenpct, updates where uniques.u_code = hundred.h_code and uniques.u_code = tenpct.t_code and uniques.u_code = updates.p_code and uniques.u_code = 'BENCHMARKS'";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+12;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_12::~CXact_OLTP_Read_Join_12 (void)
{
}

BOOL CXact_OLTP_Read_Join_12::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_12::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_12::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_JOIN_12_NUM_COLS 4
	OCIDefine* pDefineArray[OLTP_READ_JOIN_12_NUM_COLS];
	struct OLTP_READ_JOIN_12 {
		char u_date[10];
		char h_date[10];
		char t_date[10];
		char p_date[10];
	};
	typedef struct OLTP_READ_JOIN_12 OLTP_READ_JOIN_12;
	struct OLTP_READ_JOIN_12_INDICATORS {
		short u_date;
		short h_date;
		short t_date;
		short p_date;
	};
	typedef struct OLTP_READ_JOIN_12_INDICATORS OLTP_READ_JOIN_12_INDICATORS;
	OLTP_READ_JOIN_12 oltp_read_join_12_array[NUM_ROWS];
	OLTP_READ_JOIN_12_INDICATORS oltp_read_join_12_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_12_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)oltp_read_join_12_array[0].u_date, (ub2)sizeof(oltp_read_join_12_array[0].u_date), SQLT_STR, (dvoid *)&oltp_read_join_12_indicators_array[0].u_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_12_array[0].h_date, (ub2)sizeof(oltp_read_join_12_array[0].h_date), SQLT_STR, (dvoid *)&oltp_read_join_12_indicators_array[0].h_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)oltp_read_join_12_array[0].t_date, (ub2)sizeof(oltp_read_join_12_array[0].t_date), SQLT_STR, (dvoid *)&oltp_read_join_12_indicators_array[0].t_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)oltp_read_join_12_array[0].p_date, (ub2)sizeof(oltp_read_join_12_array[0].p_date), SQLT_STR, (dvoid *)&oltp_read_join_12_indicators_array[0].p_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_12_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_12_array[0]), (ub4)sizeof(oltp_read_join_12_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_12_array[iRowLoop].u_date << tab
					<< oltp_read_join_12_array[iRowLoop].h_date << tab
					<< oltp_read_join_12_array[iRowLoop].t_date << tab
					<< oltp_read_join_12_array[iRowLoop].p_date << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_12_array[iRowLoop%NUM_ROWS].u_date << tab
					<< oltp_read_join_12_array[iRowLoop%NUM_ROWS].h_date << tab
					<< oltp_read_join_12_array[iRowLoop%NUM_ROWS].t_date << tab
					<< oltp_read_join_12_array[iRowLoop%NUM_ROWS].p_date << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_12_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_13

CXact_OLTP_Read_Join_13::CXact_OLTP_Read_Join_13 (void)
{
	m_szName		= "OLTP Read Join 13";
	m_szDescription = "select uniques.u_int, uniques.u_name from uniques where uniques.u_key <= 2000000 and uniques.u_signed > (select avg(tenpct.t_signed) from tenpct where uniques.u_key = tenpct.t_key) order by u_int";
	m_szSQL			= "select uniques.u_int, uniques.u_name from uniques where uniques.u_key <= 2000000 and uniques.u_signed > (select avg(tenpct.t_signed) from tenpct where uniques.u_key = tenpct.t_key) order by u_int";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+13;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_13::~CXact_OLTP_Read_Join_13 (void)
{
}

BOOL CXact_OLTP_Read_Join_13::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_13::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_13::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_JOIN_13_NUM_COLS 2
	OCIDefine* pDefineArray[OLTP_READ_JOIN_13_NUM_COLS];
	struct OLTP_READ_JOIN_13 {
		int u_int;
		char u_name[21];
	};
	typedef struct OLTP_READ_JOIN_13 OLTP_READ_JOIN_13;
	struct OLTP_READ_JOIN_13_INDICATORS {
		short u_int;
		short u_name;
	};
	typedef struct OLTP_READ_JOIN_13_INDICATORS OLTP_READ_JOIN_13_INDICATORS;
	OLTP_READ_JOIN_13 oltp_read_join_13_array[NUM_ROWS];
	OLTP_READ_JOIN_13_INDICATORS oltp_read_join_13_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_13_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_join_13_array[0].u_int, (ub2)sizeof(oltp_read_join_13_array[0].u_int), SQLT_INT, (dvoid *)&oltp_read_join_13_indicators_array[0].u_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_13_array[0].u_name, (ub2)sizeof(oltp_read_join_13_array[0].u_name), SQLT_STR, (dvoid *)&oltp_read_join_13_indicators_array[0].u_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_13_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_13_array[0]), (ub4)sizeof(oltp_read_join_13_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_13_array[iRowLoop].u_int << tab
					<< oltp_read_join_13_array[iRowLoop].u_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_13_array[iRowLoop%NUM_ROWS].u_int << tab
					<< oltp_read_join_13_array[iRowLoop%NUM_ROWS].u_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_13_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Join_14

CXact_OLTP_Read_Join_14::CXact_OLTP_Read_Join_14 (void)
{
	m_szName		= "OLTP Read Join 14";
	m_szDescription = "select tenthou.t_key, tenthou.t_name, tenthou.t_signed, tenthou.t_code, tenpct.t_key from tenthou, tenpct where tenthou.t_code = tenpct.t_code(+) and tenthou.t_key <= 1000000";
	m_szSQL			= "select tenthou.t_key, tenthou.t_name, tenthou.t_signed, tenthou.t_code, tenpct.t_key from tenthou, tenpct where tenthou.t_code = tenpct.t_code(+) and tenthou.t_key <= 1000000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_JOIN+14;
	m_nGID			= OLTPReadJoin;
}

CXact_OLTP_Read_Join_14::~CXact_OLTP_Read_Join_14 (void)
{
}

BOOL CXact_OLTP_Read_Join_14::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_14::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_OLTP_Read_Join_14::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define OLTP_READ_JOIN_14_NUM_COLS 5
	OCIDefine* pDefineArray[OLTP_READ_JOIN_14_NUM_COLS];
	struct OLTP_READ_JOIN_14 {
		int tenthou_t_key;
		char t_name[21];
		int t_signed;
		char t_code[11];
		int tenpct_t_key;
	};
	typedef struct OLTP_READ_JOIN_14 OLTP_READ_JOIN_14;
	struct OLTP_READ_JOIN_14_INDICATORS {
		short tenthou_t_key;
		short t_name;
		short t_signed;
		short t_code;
		short tenpct_t_key;
	};
	typedef struct OLTP_READ_JOIN_14_INDICATORS OLTP_READ_JOIN_14_INDICATORS;
	OLTP_READ_JOIN_14 oltp_read_join_14_array[NUM_ROWS];
	OLTP_READ_JOIN_14_INDICATORS oltp_read_join_14_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_14_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&oltp_read_join_14_array[0].tenthou_t_key, (ub2)sizeof(oltp_read_join_14_array[0].tenthou_t_key), SQLT_INT, (dvoid *)&oltp_read_join_14_indicators_array[0].tenthou_t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)oltp_read_join_14_array[0].t_name, (ub2)sizeof(oltp_read_join_14_array[0].t_name), SQLT_STR, (dvoid *)&oltp_read_join_14_indicators_array[0].t_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&oltp_read_join_14_array[0].t_signed, (ub2)sizeof(oltp_read_join_14_array[0].t_signed), SQLT_INT, (dvoid *)&oltp_read_join_14_indicators_array[0].t_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)oltp_read_join_14_array[0].t_code, (ub2)sizeof(oltp_read_join_14_array[0].t_code), SQLT_STR, (dvoid *)&oltp_read_join_14_indicators_array[0].t_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)oltp_read_join_14_array[0].tenpct_t_key, (ub2)sizeof(oltp_read_join_14_array[0].tenpct_t_key), SQLT_INT, (dvoid *)&oltp_read_join_14_indicators_array[0].tenpct_t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < OLTP_READ_JOIN_14_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(oltp_read_join_14_array[0]), (ub4)sizeof(oltp_read_join_14_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_14_array[iRowLoop].tenthou_t_key << tab
					<< oltp_read_join_14_array[iRowLoop].t_name << tab
					<< oltp_read_join_14_array[iRowLoop].t_signed << tab
					<< oltp_read_join_14_array[iRowLoop].t_code << tab
					<< oltp_read_join_14_array[iRowLoop].tenpct_t_key << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}
		
		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< oltp_read_join_14_array[iRowLoop%NUM_ROWS].tenthou_t_key << tab
					<< oltp_read_join_14_array[iRowLoop%NUM_ROWS].t_name << tab
					<< oltp_read_join_14_array[iRowLoop%NUM_ROWS].t_signed << tab
					<< oltp_read_join_14_array[iRowLoop%NUM_ROWS].t_code << tab
					<< oltp_read_join_14_array[iRowLoop%NUM_ROWS].tenpct_t_key << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(oltp_read_join_14_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}
